#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

int cmp(const void *a, const void *b) {
    ll x = *(ll*)a, y = *(ll*)b;
    return (x > y) - (x < y);
}

ll count_pairs(ll *a, int n) {
    qsort(a, n, sizeof(ll), cmp);
    ll res = 0;
    for (int i = 0; i < n; ) {
        int j = i;
        while (j < n && a[j] == a[i]) j++;
        ll k = j - i;
        res += k * (k - 1) / 2;
        i = j;
    }
    return res;
}

int main() {
    int N;
    scanf("%d", &N);

    ll *x = malloc(N * sizeof(ll));
    ll *y = malloc(N * sizeof(ll));
    ll *xs = malloc(N * sizeof(ll));
    ll *ys = malloc(N * sizeof(ll));
    ll *sum = malloc(N * sizeof(ll));
    ll *dif = malloc(N * sizeof(ll));

    for (int i = 0; i < N; i++) {
        scanf("%lld %lld", &x[i], &y[i]);
        xs[i] = x[i];
        ys[i] = y[i];
        sum[i] = x[i] + y[i];
        dif[i] = x[i] - y[i];
    }

    ll ans = 0;
    ans += count_pairs(xs, N);   // N–S
    ans += count_pairs(ys, N);   // E–W
    ans += count_pairs(sum, N);  // N–E, S–W
    ans += count_pairs(dif, N);  // N–W, S–E

    printf("%lld\n", ans);

    return 0;
}